/*-------------------------kpi-dry basestation client V1.0---------------------------->
Written by Rohan Jhunjhunwala - rohan.jjw@gmail.com
Intellectual Property of Key Process Innovations Inc.*/

// Load the Visualization API and the corechart package.
google.charts.load('current', {
    'packages': ['line']
});
//begin web socket connection
var socket = io();

var modal = document.getElementById("id01");
var modal2 = document.getElementById("id02");
var wifiButton = document.getElementById("wifibutton");
var swBtn = document.getElementById("fwup");
var keyField = document.getElementById("keytext");
var ssidField = document.getElementById("ssidtext");
var URLfield = document.getElementById("urltext");

if(swBtn){
	swBtn.addEventListener("click", function(){
		socket.emit("updateurl", URLfield.value);
	});
}

if(wifiButton){
    wifiButton.addEventListener("click", function(){
        socket.emit("wifi", [ssidField.value, keyField.value]);
        wifiButton.innerHTML = "Connecting...";
    });
}

socket.on("wifiack", function(data) {
    console.log(data);
    if(data == "success"){
        wifiButton.innerHTML = "Connected!"
        wifiButton.disabled = true;
    }
    else{
        wifiButton.innerHTML = "Connect"
    }
});

window.onclick = function(event) {
  if (event.target == modal) {
    	modal.style.display = "none";
    console.log('Window.Onclick')
  }

  if (event.target == modal2) {
  		modal2.style.display = "none";
	}
}

var logData = null;
var logIntvl = document.getElementById("logIntvlSlider");
var LEDint = document.getElementById("LEDintSlider");
var LEDbright = document.getElementById("LEDbrightSlider");
var v1 = document.getElementById("LIVal");
var v2 = document.getElementById("LEDintVal");
var v3 = document.getElementById("LEDbrightVal");

v1.innerHTML = logIntvl.value;
v2.innerHTML = LEDint.value;
v3.innerHTML = LEDbright.value;

logIntvl.oninput = function() {
    v1.innerHTML = this.value;
    socket.emit("SendControls", {logint: this.value, led_bright: v3.innerHTML, led_int: v2.innerHTML});
}
LEDint.oninput = function() {
    v2.innerHTML = this.value;
    socket.emit("SendControls", {logint: v1.innerHTML, led_bright: v3.innerHTML, led_int: this.value});
}
LEDbright.oninput = function() {
    v3.innerHTML = this.value;
    socket.emit("SendControls", {logint: v1.innerHTML, led_bright: this.value, led_int: v2.innerHTML});
}


//status display labels
var logstatus = document.getElementById("statusLbl");
//var channel = document.getElementById("chanLbl");
var battery = document.getElementById("battLbl");
var fw = document.getElementById("fwLbl");
var hw = document.getElementById("hwLbl");
var logInt = document.getElementById("logIntLbl");
var updateTime = document.getElementById("updateTimeLbl");
var numData = document.getElementById("numDataLbl");
var mem = document.getElementById("memLbl");
var serial = document.getElementById("serLbl");
//var numUpdates = document.getElementById("numUpdatesLbl");
var s1t = document.getElementById("s1tLbl");
var s1h = document.getElementById("s1hLbl");
var s2t = document.getElementById("s2tLbl");
var s2h = document.getElementById("s2hLbl");
var message = document.getElementById("msg");

//control input buttons
var beginBtn = document.getElementById("beginBtn");
var stopBtn = document.getElementById("stopBtn");
var eraseBtn = document.getElementById("eraseBtn");
var updateBtn = document.getElementById("updateBtn");
var loadBtn = document.getElementById("loadBtn");
var saveBtn = document.getElementById("saveBtn");

//button click event listeners
if(beginBtn) {
    beginBtn.addEventListener("click", function() {
        var state = beginBtn.innerHTML;
        if(state == "Begin"){
            socket.emit("begin", 0);
            beginBtn.innerHTML = "Stop";

        }
        else if(state == "Stop"){
            socket.emit("stop", 0);
            beginBtn.innerHTML = "Begin";
        }
    });
}
if(eraseBtn) {
    eraseBtn.addEventListener("click", function() {
        socket.emit("erase", 0)
    });
}
if(updateBtn) {
    console.log('update');
    updateBtn.addEventListener("click", function() {
        socket.emit("update", 0)
    });
}
if(loadBtn) {
    loadBtn.addEventListener("click", function() {
        socket.emit("load", 0)
    });
}
if(saveBtn) {
    saveBtn.addEventListener("click", function() {
        socket.emit("save", 0)
    });
}

//incoming data recieve listeners
socket.on('debug', function(data) {
        console.log('Debug Info: ', data);
});

socket.on('LogCount', function(data) {
	if(loadBtn) {
		if(data.curr < (data.total - 1)) {
		loadBtn.innerHTML = data.curr + " of " + data.total;
		}
		else {
			loadBtn.innerHTML = "Load";
		}
	}
});

socket.on('Status', function(data) {
    if(logstatus){
        logstatus.innerHTML = data;
        if(data == "Logging"){
            beginBtn.innerHTML = "Stop";
        }
        else {
            beginBtn.innerHTML = "Begin";
        }
    }
});
socket.on('SerialNumber', function(data) {
    if(serial){
        serial.innerHTML = data;
    }
});
socket.on('BatteryLife', function(data) {
    if(battery){
        battery.innerHTML = data+"%";
    }
});
socket.on('SoftwareVersion', function(data) {
    if(fw){
        fw.innerHTML = data;
    }
});
socket.on('LogInterval', function(data) {
    if(logInt){
        logInt.innerHTML = data+" minutes";
        v1.innerHTML = data;
    }
});
socket.on('LEDInterval', function(data) {
    console.log('ledInterval: ', data);
        v2.innerHTML = data;
});
socket.on('LEDBrightness', function(data) {
    console.log('led_brightness: ', data);
        v3.innerHTML = data;
});
socket.on('Humidity1', function(data) {
    if(s1h){
        if(data == 3276.7){
            data = "N/A"
        }
        else{
            data = data+"%"
        }
        s1h.innerHTML = data;
    }
});
socket.on('Temperature1', function(data) {
    if(s1t){
        if(data == 3276.7){
            data = "N/A"
        }
        else{
            data = data+"°C"
        }
        s1t.innerHTML = data;
    }
});
socket.on('Humidity2', function(data) {
    if(s2h){
        if(data == 3276.7){
            data = "N/A"
        }
        else{
            data = data+"%"
        }
        s2h.innerHTML = data;
    }
});
socket.on('Temperature2', function(data) {
    if(s2t){
        if(data == 3276.7){
            data = "N/A"
        }
        else{
            data = data+"°C"
        }
        s2t.innerHTML = data;
    }
});
/*socket.on('LEDInterval', function(data) {
    status.innerHTML = data;
}
socket.on('LEDBrightness', function(data) {
    status.innerHTML = data;
}*/
socket.on('Warnings', function(data) {
    if(msg){
        if(data == 0){
            data = "No Messages";
        }
        msg.innerHTML = data;
    }
});
socket.on('NumDatapoints', function(data) {
    if(numData){
        numData.innerHTML = data;
    }
});
socket.on('MemoryRemaining', function(data) {
    if(mem){
        mem.innerHTML = data+" slots";
    }
});
socket.on('HardwareRevision', function(data) {
    if(hw){
        hw.innerHTML = data;
    }
});

socket.on('Time', function(data) {
    if(updateTime){
        var time = new Date(data);
        updateTime.innerHTML = time.getMonth()+'/'+time.getDate()+'/'+time.getFullYear().toString().substr(-2)+" "+time.getHours()+':'+("0"+time.getMinutes().toString()).substr(-2);
    }
});

socket.on('LogData', function(data){
    logData = data;
    drawChart();
});


// Set a callback to run when the Google Visualization API is loaded.
google.charts.setOnLoadCallback(drawChart);

// Callback that creates and populates a data table,
// instantiates the pie chart, passes in the data and
// draws it.
function drawChart() {
    if(logData != null){
        // Create the data table.
        var data = new google.visualization.DataTable();
        data.addColumn('datetime', 'Time');
        data.addColumn('number', 'Sensor 1 Temp');
        data.addColumn('number', 'Sensor 1 RH');
        data.addColumn('number', 'Sensor 2 Temp');
        data.addColumn('number', 'Sensor 2 RH');

        for(var i=0; i<logData.length;i++){
            //var time = new Date(logData[i][0]);
            var time = new Date(logData[i][0]);
            //logData[i][0]= new Date(time.getFullYear(), (time.getMonth() - 1), time.getDay(), time.getHours(), time.getMinutes());
            logData[i][0] = time;
        } 

        data.addRows(logData);

        // Set chart options
        var materialOptions = {
            width: 1000,
            height: 500,
            curveType: 'function',
            series: {
                0: {axis: 'Temp'},
                1: {axis: 'Hum'},
                2: {axis: 'Temp'},
                3: {axis: 'Hum'}
            },
            axes: {
                y: {
                    viewWindowMode: "explicit",
                    viewWindow:{ min: 0 },
                    Temp: {label: 'Temperature (°C)', minValue: 0},
                    Hum: {label: 'Relative Humidity (%)', minValue: 0},
                }
            }
        };

        var chart = new google.charts.Line(document.getElementById('chart_div'));

        chart.draw(data, materialOptions);
    }
}


