var express = require('express');
var app = express();
var server = app.listen(8080);
var io = require('socket.io').listen(server);
var path = require('path')
var piWifi = require('pi-wifi');
var fs = require('fs');
var AdmZip = require('adm-zip');
var wget = require('node-wget');

var filePath = '/home/pi/kpidry/public/data/data.csv';
const createCsvWriter = require('csv-writer').createObjectCsvWriter;
const csvWriter = createCsvWriter({
	path: filePath,
	header: [
	{id: 'Time', title: 'Time'},
	{id: 'Temp1', title: 'Temperature 1'},
	{id: 'Hum1', title: 'Humidity 1'},
	{id: 'Temp2', title: 'Temperature 2'},
	{id: 'Hum2', title: 'Humidity 2'},
    {id: 'BattLife', title: 'Battery Life'}]
});

var SerialPort = require('serialport');
var sp;
//var socketExists = false;  //start without an existing socket
var mySocket = null;

const BEEFNUM = 4; //number of bytes in DEADBEEF
const HEADERLENGTH = 16; // number of bytes in a header
var DEADBEEF = [0xEF, 0xBE, 0xAD, 0xDE];
var message = DEADBEEF; //initial message just contains the DEADBEEF identifier
var messageindex = 0; // index of the received message
var beefcounter = 0; // counting valid bytes of DEADBEEF
var messageDataLength = 0; // length of the data message in bytes.

// set the discrete steps of LED brightness
const ledBright_Min = 1;
const ledBright_Max = 30;   
const brightnessResolution = 255;  // the largest number for led brightness that the datalogger can accept.

const host_IDs = {
    HOST_ID_PI: 0,
    Datalogger_ID: 1,
    Datalogger_ID_Default: 11, // default target ID
    Datalogger_ID_Max: 254,
    HOST_ID_GUI: 255
}
var hostID = host_IDs.HOST_ID_GUI

const messageStates = {
    FindBeef: 'FindBeef',
    ReceiveHeader: 'ReceiveHeader',
    ReceiveData: 'ReceiveData',
    MessageReceived: 'MessageReceived'
}
var messageState = messageStates.FindBeef;
// Indexes for the message
const messageIndexes = {
    msgid: 4, // message id
    Databytes: 12,
    Checksum: 14,
    data: 16
}
var messageLoc = messageIndexes;

// message ids
const messageids = {
    MSG_INVALID: 0,
    //GUI TO TARGET
    MSG_QUERY_STATUS: 32, // query target status
    MSG_SET_TARGET_ID: 33, // set target ID
    MSG_ENABLE_LOGGING: 34, // enable/disable logging
    MSG_TARGET_CONTROL: 35, // Control settings
    MSG_ERASE_EEPROM: 36, // Erase target EEPROM
    MSG_SET_DATE_TIME: 37, // set date/time in target
    MSG_REQUEST_LOG_DATA: 38, // request to send all log data
    MSG_TEST_EEPROM: 39, // request to test EEPROM
    MSG_GO_TO_DFU: 40, // request to enter DFU (firmware update) mode  (Only works when coming in on USB directly!)
    MSG_SET_SERIALNUMBER: 41,
    // Target to GUI
    MSG_TARGET_CONNECT: 48, // target has joined network
    MSG_TARGET_STATUS: 49, // target status data
    MSG_TARGET_ID_SET: 50, // response to set target ID message
    MSG_TARGET_LOG_DATA: 51, // target log data from EEPROM
    MSG_GO_TO_DFU_ACK: 52, // request to enter DFU (firmware update) mode acknowledge
    MSG_DEBUG_PRINT: 64
}
var messageid = messageids;

var DLStatus = {
    SerNum: 'unset',
    status: 'unknown',
    battery_life: 0.0,
    sw_version: 0,
    log_interval: 0,
    year: 2008,
    month: 1,
    day: 1,
    hour: 0,
    minute: 0,
    second: 0,
    led_control: 0,
    humidity_1: 0.0,
    temp_1: 0,
    humidity_2: 0,
    temp_2: 0,
    led_interval: 0,
    led_brightness: 0,
    warnings: 0,
    num_data_points: 0,
    qi1: 0,
    rssi: 0,
    memory_remaining: 0,
    hwRevision: 0,
    unitSerialNumber: "Unset",
    spare: 0
}
var currentstatus = DLStatus;

var LogDataStruct = {
    curr: 0, // the current item in the array
    total: 0, // the total number of items in the array
    year: 2008,
    month: 1,
    day: 1,
    hour: 0,
    minute: 0,
    second: 0,
    errors: 0,
    Temp_1: 0,
    Humidity_1: 0,
    Temp_2: 0,
    Humidity_2: 0,
    battery_life: 0,
    spare: 0
}
var LogDataItem = LogDataStruct; // the fields that are with each message of log data
var LogData = [LogDataItem]; //an array of log data items
//var ReceivingLogData = false; // a flag to show when we are still receiving log data from the eeprom

/*var GraphDataStruct = {
	Date: 0,
	Temp1: 0,
	Humidity1: 0,
	Temp2: 0,
	Humidity2: 0
}
var GraphDataItem = GraphDataStruct;
var GraphData = [GraphDataItem]; */
var GraphData = [];
var CsvData = [];

var GUILogDataStruct = {
	DateTime: 0,   // date and time combined
	Temp1: 0, 
	Humidity1: 0,
	Temp2: 0,
	Humidity2: 0
}
var GUILogDataItem = GUILogDataStruct;
var GUILogData = [GUILogDataItem];  // array of log data items for the GUI

app.use(express.static(path.join(__dirname, 'public')));
app.get('/', function (req, res) {
  res.sendFile(__dirname + '/public/index.html');
});

console.log(__dirname);

sp = new SerialPort('/dev/ttyS0', {
    baudRate: 115200
});

io.sockets.on('connection', function(socket) { // Web Socket Connection
    console.log('connected');
    mySocket = socket;
    var TxDataBytes = [0x00];  // databytes to send in the message

    mySocket.on("begin", function(data) {
    	console.log('begin');
    	TxDataBytes = [0x01];
    	sendMessage(makemessage(messageid.MSG_ENABLE_LOGGING, host_IDs.Datalogger_ID_Default, TxDataBytes)); // send the begin logging message to the datalogger
    })

    mySocket.on("stop", function(data) {
    	console.log('stop');
    	TxDataBytes = [0x00];
    	sendMessage(makemessage(messageid.MSG_ENABLE_LOGGING, host_IDs.Datalogger_ID_Default, TxDataBytes)); // send the stop logging message to the datalogger
    })

    mySocket.on("erase", function(data) {
    	console.log('erase');
    	TxDataBytes.pop();
    	sendMessage(makemessage(messageid.MSG_ERASE_EEPROM, host_IDs.Datalogger_ID_Default, TxDataBytes)); //  message to erase EEPROM
    })

    mySocket.on("update", function(data) {
    	console.log('Query');
    	TxDataBytes.pop();
    	sendMessage(makemessage(messageid.MSG_QUERY_STATUS, host_IDs.Datalogger_ID_Default, TxDataBytes)); //  Query Datalogger status
    }) 

    mySocket.on("load", function(data) {
    	console.log('Load');
    	TxDataBytes.pop();
    	sendMessage(makemessage(messageid.MSG_REQUEST_LOG_DATA, host_IDs.Datalogger_ID_Default, TxDataBytes)); //  load logged data
    }) 

    mySocket.on("SendControls", function(data) {
    	console.log('Send Controls');
    //	console.log('SendControlData: ', data)
    	var logInterval = data.logint & 0xFF;
    	var ledBrightness = Math.round(((data.led_bright / ledBright_Max) * brightnessResolution)) & 0xFF; 
    	var ledInterval = data.led_int & 0xFFFF;
    	TxDataBytes = [logInterval, ledBrightness, ledInterval&0xFF, (ledInterval>>8) & 0xFF, 0x00, 0x00, 0x00, 0x00];
    	sendMessage(makemessage(messageid.MSG_TARGET_CONTROL, host_IDs.Datalogger_ID_Default, TxDataBytes));
    })

    mySocket.on("wifi", function(data){
        console.log("ssid: "+data[0]);
        console.log("key: "+data[1]);
        var networkDetails = {
            ssid: data[0],
            password: data[1],
        }
        piWifi.connectTo(networkDetails, function(err) {
            if(!err) {
                console.log('wifi connected');
                mySocket.emit("wifiack", "success");
            } else {
                console.log(err.message); //Failed to connect
                mySocket.emit("wifiack", err.message);
            }
        });

    });

    mySocket.on("updateurl", function(data){
    console.log("updateURL: "+data);
    wget(data, function(error){
        if(!error){
            var zip = new AdmZip("./kpidry.zip");
            zip.extractAllTo("/home/pi/update/", true);
        }
    });
    
    msg = "Update Reboot";
    require('child_process').exec('sudo /sbin/shutdown -r now', function (msg) { console.log(msg) });
});

});

function GUIDisplayStatus(){
    //send data to the web connection
    if (currentstatus.status == 0x00) { //decifer the status
        statusString = 'OFF'; // we are not logging
    } else if (currentstatus.status == 0x01) {
        statusString = 'Logging'; // we are logging if status is 0x01
    } else {
        statusString = 'Error';
    }

    var TimeRead = new Date(currentstatus.year, currentstatus.month, currentstatus.day, currentstatus.hour, currentstatus.minute);
    if(mySocket){
        mySocket.emit('Status', statusString);
        mySocket.emit('SerialNumber', currentstatus.unitSerialNumber); // Should be a string
        mySocket.emit('BatteryLife', currentstatus.battery_life); // battery life multiplied by ten to make it a percentage since it's reported in 1/10th of a percent
        mySocket.emit('SoftwareVersion', currentstatus.sw_version);
        mySocket.emit('LogInterval', currentstatus.log_interval);
 //       mySocket.emit('Date', DateRead);
        mySocket.emit('Time', TimeRead);
        mySocket.emit('Humidity1', currentstatus.humidity_1);
        mySocket.emit('Temperature1', currentstatus.temp_1); // in Celcius
        mySocket.emit('Humidity2', currentstatus.humidity_2);
        mySocket.emit('Temperature2', currentstatus.temp_2);
        mySocket.emit('LEDInterval', currentstatus.led_interval); // Can skip for now
        //need to scale brightness appropriately:
        var adjustedBrightness = Math.round(ledBright_Max * currentstatus.led_brightness / brightnessResolution);
  //      console.log('adjustedBrightness', adjustedBrightness);
 //      console.log('currentstatus: ', currentstatus);
        mySocket.emit('LEDBrightness', adjustedBrightness); 
        mySocket.emit('Warnings', currentstatus.warnings); 
        mySocket.emit('NumDatapoints', currentstatus.num_data_points);
        mySocket.emit('MemoryRemaining', currentstatus.memory_remaining);
        mySocket.emit('HardwareRevision', currentstatus.hwRevision);
    }
}

function SendLogDatatoGUI(graphArray) {
	if(mySocket) {
		mySocket.emit('LogData', GraphData);
	//	console.log('GraphData: ', GraphData);
	}
}

sp.on('data', function(data) {
    var dataindex; //index of the data array
 //   console.log('socketON ', io.sockets.connected());
 //   sp.pause();
    for (dataindex = 0; dataindex < data.length; dataindex++) {
        switch (messageState) {
            case messageStates.FindBeef:
                if (data[dataindex] == DEADBEEF[messageindex]) {
                    messageindex++;
                    beefcounter++;
                } else {
                    messageindex = 0; // if we didn't find the beef, reset the message index to 0
                    beefcounter = 0; // Also reset the beefcounter to 0
                }
                if (beefcounter == BEEFNUM) {
                    messageState = messageStates.ReceiveHeader;
                    beefcounter = 0; // We found beef, so let's reset the counter
                }
                break;
            case messageStates.ReceiveHeader: // complete the header
                message.push(data[dataindex]);
                messageindex++;
                if (messageindex >= HEADERLENGTH) {
                    messageDataLength = (message[messageLoc.Databytes + 1] << 8) + message[messageLoc.Databytes];
                    messageState = messageStates.ReceiveData;
                }
                break;
            case messageStates.ReceiveData: // we have a complete header, now to receive the data package
                messageindex++;
                if (messageindex < (HEADERLENGTH + messageDataLength)) {
                    message.push(data[dataindex]);
                } else {
                    message.push(data[dataindex]);
                    messageState = messageStates.MessageReceived;
                    messageState = messageStates.FindBeef; // Where's the beef yo?
                    processmessage(); // process the received message
                    erasemessage(); // once the message is parsed we can erase it
                    messageindex = 0; // reseet the message index
                }
                break;
            case messageStates.MessageReceived: // we have received a complete message
                break;
        }
    }
 //   sp.resume();
    //  sendMessage(makemessage(messageid.MSG_QUERY_STATUS, host_IDs.Datalogger_ID_Default, 0));
})

function erasemessage() {
    while (message.length > 4) {
        message.pop(); // remove elements from the array
    }
    messageindex = 0;
    return;
}

function eraseArray(array, finalLength) {
    while (array.length > finalLength) {
        array.pop();
    }
    return array;
}

function processmessage() {
	//First Makesure the Checksum is correct:
//	console.log('message precheck: ', message);
	var headerwochecksum = message.slice(0, messageLoc.Checksum);
	var msgData = message.slice(messageLoc.data);
	var msgChecksum = (message[messageLoc.Checksum] + (message[messageLoc.Checksum + 1] << 8)) & 0xFFFF;
	var calculatedchecksum = calculateChecksum(headerwochecksum, msgData);
	//console.log('ProcessMessage: ', message)
	if (msgChecksum != calculatedchecksum) {
		console.log('Invalid Checksum');
//		console.log('headerwochecksum: ', headerwochecksum);
//		console.log('msgData: ', msgData);
		console.log('msgChecksum: ', msgChecksum);
		console.log('CalculatedChecksum: ', calculatedchecksum);
//		console.log('message: ', message);
		return;

	}

    switch (message[messageLoc.msgid]) {

        case messageid.MSG_DEBUG_PRINT:
            console.log('debug/print');
            var debugString = String.fromCharCode.apply(null, message.slice(messageLoc.data, message.length));
            if(mySocket){
        		mySocket.emit('debug', debugString);
        	}
            //console.log(String.fromCharCode.apply(null, message.slice(messageLoc.data, message.length)));
            break;
        case messageid.MSG_TARGET_CONNECT:
            console.log('Target Connect');
            var currentDate = new Date();
            var yearMSB = (currentDate.getFullYear() >> 8) & 0xFF;
            var yearLSB = (currentDate.getFullYear()) & 0xFF;
			var DateTimeBytes = [yearLSB, yearMSB, (currentDate.getMonth() + 1), currentDate.getDate(), currentDate.getHours(), currentDate.getMinutes(), currentDate.getSeconds(), 0];
			sendMessage(makemessage(messageid.MSG_SET_DATE_TIME, host_IDs.Datalogger_ID_Default, DateTimeBytes));  // send updated time and date to the datalogger
		//	console.log('DateTimeBytes', DateTimeBytes);
            break;
        case messageid.MSG_TARGET_STATUS:
            console.log('Target Status');
            var j = messageLoc.data;
	   // var minutestring = 0;
            //console.log('statusmsg: ', message);
            currentstatus.SerNum = message[j++];
            currentstatus.status = message[j++];
            currentstatus.battery_life = (message[j++] + (message[j++] << 8)) / 10;
            currentstatus.sw_version = message[j++];
            currentstatus.log_interval = message[j++];
            currentstatus.year = message[j++] + (message[j++] << 8);
            currentstatus.month = message[j++];
            currentstatus.day = message[j++];
            currentstatus.hour = message[j++];
	   // minutestring = ("0" + message[j++].toString().slice(-2));
            currentstatus.minute = ("0" + message[j++].toString()).substr(-2);
            currentstatus.second = message[j++];
            currentstatus.led_control = message[j++];
            currentstatus.humidity_1 = (message[j++] + (message[j++] << 8)) / 10;
            currentstatus.temp_1 = (message[j++] + (message[j++] << 8)) / 10;
            currentstatus.humidity_2 = (message[j++] + (message[j++] << 8)) / 10;
            currentstatus.temp_2 = (message[j++] + (message[j++] << 8)) / 10;
            currentstatus.led_interval = message[j++] + (message[j++] << 8);
            currentstatus.led_brightness = message[j++];
            currentstatus.warnings = message[j++];
            currentstatus.num_data_points = message[j++] + (message[j++] << 8);
            currentstatus.qi1 = message[j++];
            currentstatus.rssi = message[j++];
            currentstatus.memory_remaining = message[j++] + (message[j++] << 8);
            currentstatus.hwRevision = message[j++];
            var unitSerNum = [message[j++]];
            for(var p = 1; p < 10; p++){
                unitSerNum.push(message[j++]); 
            }
            currentstatus.unitSerialNumber = "";
            for(var q = 0; q < unitSerNum.length; q++) {
                currentstatus.unitSerialNumber += String.fromCharCode(unitSerNum[q]);
            }
            //DisplayStatus();
            GUIDisplayStatus();
            
            //console.log('Socket: ', socket.connected);
            break;
        case messageid.MSG_TARGET_ID_SET:
            console.log('Target ID Set');
            break;
        case messageid.MSG_TARGET_LOG_DATA:
        	console.log('MSG_TARGET_LOG_DATA');
            var k = messageLoc.data;
            var graphelementarray = [0,0,0,0,0];
            var csvelementarray = [0,0,0,0,0,0];
            var LogDataElement = new Object();

            LogDataElement.curr = message[k++] + (message[k++] << 8);
            LogDataElement.total = message[k++] + (message[k++] << 8);
            LogDataElement.year = message[k++] + (message[k++] << 8);
            LogDataElement.month = message[k++];
            LogDataElement.day = message[k++];
            LogDataElement.hour = message[k++];
            LogDataElement.minute = (("0"+message[k++].toString()).substr(-2));
//		console.log('minutes: ', LogDataElement.minute);
            LogDataElement.second = message[k++];
            LogDataElement.errors = message[k++];
            LogDataElement.Temp_1 = convertLEndianFloatArraytoFloat([message[k++], message[k++], message[k++], message[k++]]);
            LogDataElement.Humidity_1 = convertLEndianFloatArraytoFloat([message[k++], message[k++], message[k++], message[k++]]);
            LogDataElement.Temp_2 = convertLEndianFloatArraytoFloat([message[k++], message[k++], message[k++], message[k++]]);
            LogDataElement.Humidity_2 = convertLEndianFloatArraytoFloat([message[k++], message[k++], message[k++], message[k++]]);
            LogDataElement.battery_life = convertLEndianFloatArraytoFloat([message[k++], message[k++], message[k++], message[k++]]);
            LogDataElement.spare = convertLEndianFloatArraytoFloat([message[k++], message[k++], message[k++], message[k++]]);

            var date = new Date(LogDataElement.year, LogDataElement.month-1, LogDataElement.day, LogDataElement.hour, LogDataElement.minute);
            //var msDate = date.getTime();
            //var date = new Date(LogDataElement.year, LogDataElement.month, LogDataElement.day, LogDataElement.hour, LogDataElement.minute);
            

            var GraphDataElement = new Object();

            graphelementarray[0] = date;
            graphelementarray[1] = LogDataElement.Temp_1;
            graphelementarray[2] = LogDataElement.Humidity_1;
            graphelementarray[3] = LogDataElement.Temp_2;
            graphelementarray[4] = LogDataElement.Humidity_2;

            csvelementarray[0] = date;
            csvelementarray[1] = LogDataElement.Temp_1;
            csvelementarray[2] = LogDataElement.Humidity_1;
            csvelementarray[3] = LogDataElement.Temp_2;
            csvelementarray[4] = LogDataElement.Humidity_2;
            csvelementarray[5] = LogDataElement.battery_life;

 		if (LogDataElement.curr == 0) { // if we are at the first item, then be sure our array is empty before proceeding
                LogData = eraseArray(LogData, 0);
                GraphData = eraseArray(GraphData, 0);
                CsvData = eraseArray(CsvData, 0);
                console.log('eraseArray');
            }
            LogData.push(LogDataElement); //push the log item onto the array
            GraphData.push(graphelementarray);
            CsvData.push(csvelementarray);

            if(mySocket) {
                   mySocket.emit('LogCount', {curr: LogDataElement.curr, total: LogDataElement.total});
                    //  console.log('GraphData: ', GraphData);
            }

            if(LogDataElement.curr < (LogDataElement.total - 1)) {
            //if (LogData[LogData.length].curr < LogDataElement.total) {
            //    SendLogDatatoGUI(GraphData); // Send the graph array to the GUI for processing              
            //    createCSV(GraphData);  // create the csv file of the graphed data
                
            //    console.log('length: ', LogData.length);
            //    console.log('current: ', LogData[LogData.length-1].curr);
            //    console.log('total: ', LogDataElement.total);
		//console.log('GraphData: ', GraphData);
             }
            else {  // If we have all the log data we can pass the array to the GUI
            //    console.log('GraphDataLength: ', GraphData.length);
            	SendLogDatatoGUI(GraphData); // Send the graph array to the GUI for processing          	
                createCSV(CsvData);  // create the csv file of the graphed data
            //    console.log('LogData: ', LogData);
            //    console.log('GraphData: ', GraphData);
 //               LogData = eraseArray(LogData, 0);
 //               GraphData = eraseArray(GraphData, 0);
            }
            break;
    }
}

function createCSV(datatowrite) {
	var csvdata = [];
	eraseArray(csvdata, 0);   // be sure the array is empty
	var k;
	var formattedTime;
    fs.unlinkSync(filePath); // delete any existing file before re-writing.
	for(k=0; k<datatowrite.length; k++) {
		var time = new Date(datatowrite[k][0]);
	//	formattedTime = ("" + time.getFullYear() + '/' + time.getMonth() + '/' + time.getDay() + '-' + time.getHours() + ':' + time.getMinutes());
	//	console.log('formattedTime: ', formattedTime);
        formattedTime = (time.getMonth()+1)+'/'+time.getDate()+'/'+time.getFullYear().toString().substr(-2)+" "+time.getHours()+':'+("0"+time.getMinutes().toString()).substr(-2);
		csvdata[k] =
		{
			Time: formattedTime,
			Temp1: datatowrite[k][1],
			Hum1: datatowrite[k][2],
			Temp2: datatowrite[k][3],
			Hum2: datatowrite[k][4],
            BattLife: datatowrite[k][5] + '%'
		};
	}
//	console.log('csvdata: ', csvdata);
	csvWriter.writeRecords(csvdata);
}

function convertLEndianFloatArraytoFloat(L_Endian_floatArray32) {
	var buf = new ArrayBuffer(4);
    var view = new DataView(buf);
	var floatArray32 = [L_Endian_floatArray32[3], L_Endian_floatArray32[2], L_Endian_floatArray32[1], L_Endian_floatArray32[0]];  //Put the array in the correct order
	
	floatArray32.forEach(function(b, i) {
		view.setUint8(i, b);
	});

	return Math.round(view.getFloat32(0) * 10) / 10;  // let's go ahead and return the 64 bit float but round it to the tens place
}

/*function ParseLogDataForGUI() {
	GUILogData = eraseArray(GUILogData, 0);  // assume the array needs erased to build a new one
//	var GUILogItem = new Object();
	

	var G;   // index counter for GuiLogData
	var GraphArray = [];   // If Rohan prefers this format we will send him an array formatted as such
	var DateTime;
//	console.log('LogData_inParse: ', LogData);
	for(G = 0; G < LogData.length; G++) {
		DateTime = [LogData[G].year, LogData[G].month, LogData[G].day, LogData[G].hour, LogData[G].minute];
		var GUILogItem = new Object();
			GUILogItem.DateTime = DateTime.getTime();
			GUILogItem.Temp1 = LogData[G].Temp_1;
			GUILogItem.Humidity1 = LogData[G].Humidity_1;
			GUILogItem.Temp2 = LogData[G].Temp_2;
			GUILogItem.Humidity2 = LogData[G].Humidity_2;
//		GUILogData.push(GUILogItem);   //Load the log items to the array  (one possible format)
		GraphArray.push([GUILogItem.DateTime, GUILogItem.Temp1, GUILogItem.Humidity1, GUILogItem.Temp2, GUILogItem.Humidity2]);
		console.log('GraphArray: ', GraphArray);
	}
	return GraphArray;  // optional, depends on formatting Rohan wants
} */

function displayLogData() {
    var p;
    for (p = 0; p < LogData.length; p++) {
        console.log('-----------------------------------------');
        console.log('curr: ', LogData[p].curr);
        console.log('total: ', LogData[p].total);
        console.log('year: ', LogData[p].year);
        console.log('month: ', LogData[p].month);
        console.log('day: ', LogData[p].day);
        console.log('hour: ', LogData[p].hour);
        console.log('minute: ', LogData[p].minute);
        console.log('second', LogData[p].second);
        console.log('errors', LogData[p].errors);
        console.log('Temp 1: ', LogData[p].Temp_1);
        console.log('Humidity 1: ', LogData[p].Humidity_1);
        console.log('Temp 2: ', LogData[p].Temp_2);
        console.log('Humidity 2', LogData[p].Humidity_2);
        console.log('Battery Life', LogData[p].battery_life);
        console.log('spare: ', LogData[p].spare);
        console.log('-----------------------------------------');
    }
}

function DisplayStatus() {
    console.log('Status: ', currentstatus.status);
    console.log('Battery life: ', currentstatus.battery_life, '%');
    console.log('sw version: ', currentstatus.sw_version);
    console.log('Log Interval: ', currentstatus.log_interval, ' minutes');
    console.log('Date: ', currentstatus.month, '/', currentstatus.day, '/', currentstatus.year);
    console.log('Time: ', currentstatus.hour, ':', currentstatus.minute, ':', currentstatus.second);
    console.log('Humidity 1: ', currentstatus.humidity_1, '%');
    console.log('Temperature 1: ', currentstatus.temp_1, 'C');
    console.log('Humidity_2: ', currentstatus.Humidity_2, '%');
    console.log('Temperature 2: ', currentstatus.temp_2, 'C');
    console.log('LED Interval: ', currentstatus.led_interval, ' seconds');
    console.log('Number of Data Points: ', currentstatus.num_data_points);
    console.log('Memory Remaining: ', currentstatus.memory_remaining);
    console.log('hwRevision: ', currentstatus.hwRevision);
    console.log('Unit Serial Number: ', currentstatus.unitSerialNumber); 
}

// TRANSMITTING

function calculateChecksum(headerNochecksum, data_bytes) { //Calculates the sum of all data bytes and header bytes
    var checksumResult = 0x0000; //begin checksum with value of zero
    var ii; //the header index/counter
    var jj; // the data index/counter
    for (ii = 0; ii < (headerNochecksum.length); ii++) { // the -2 is to skip the checksum field
        checksumResult += headerNochecksum[ii];
    }
    for (jj = 0; jj < data_bytes.length; jj++) {
        checksumResult += data_bytes[jj];
    }
    return (checksumResult & 0xFFFF);
}

function makemessage(msg_id, Target_ID, data_bytes) {
//	console.log('TxMessagepreDEADBEEF: ', TxMessage);
	var TxMessage = DEADBEEF;
    
    var checksum = 0x0000;
    var numofdatabytes = 0x00
    if (data_bytes != 'none') {
    	numofdatabytes = data_bytes.length;
    }
    if(TxMessage.length > 4) {
    	 TxMessage = eraseArray(TxMessage, 4);
    }
//	console.log('TxMessageprePostBEEF: ', TxMessage);
    //First create the header
    TxMessage.push(msg_id & 0xFF); // Add the message id
    TxMessage.push(hostID & 0xFF); // add host id from enum
    TxMessage.push(Target_ID & 0xFF); //destination 
    TxMessage.push(0x00); //for alignment
    TxMessage.push(0x00);
    TxMessage.push(0x00);
    TxMessage.push(0x00);
    TxMessage.push(0x00); // for double alignment
    TxMessage.push(data_bytes.length & 0xFF);
    TxMessage.push((data_bytes.length >> 8) & 0xFF); // number of databytes
    checksum = calculateChecksum(TxMessage, data_bytes); // calculate the checksum
    TxMessage.push(checksum & 0xFF); //checksum
    TxMessage.push((checksum >> 8) & 0xFF);
    //  console.log("checksum: ", calculateChecksum(TxMessage, data_bytes));
    var i;
    for (i = 0; i < numofdatabytes; i++) {
        TxMessage.push(data_bytes[i]); // load the bytes into the message array
    }
    //console.log('TxMessage: ', TxMessage);
    return TxMessage; // return a full message
}

function sendMessage(TX_message) {
  //  console.log('SendMessage: ', TX_message);
    sp.write(TX_message);
};


